# https://snap.berkeley.edu/snap/snap.html#present:Username=jordibinefa&ProjectName=toyMqtt

import paho.mqtt.client as mqtt
import time
import iotv
import requests

# --- CONFIGURACIÓ ---
ROOT_TOPIC = "/toy0"
NUM_TOY = "1"

# Adreça de la vèrtebra
VERTEBRA = "0x0"
RIB_OUT = "b"
RIB_IN = "a"

# --- CALLBACKS (Nivell Global) ---
def handle_message(client, userdata, msg):
    payload = msg.payload
    topic = msg.topic
    print("topic: ", topic, " , payload: ", payload)

    # Comprovem el topic de LEDs
    if topic == ROOT_TOPIC + "/leds" + "/" + NUM_TOY:
        if payload == "R":
            print("vermell")
            iotv.doutbit(VERTEBRA, RIB_OUT, 0, 1)
            iotv.doutbit(VERTEBRA, RIB_OUT, 1, 0)
            iotv.doutbit(VERTEBRA, RIB_OUT, 2, 0)
        if payload == "M":
            iotv.doutbit(VERTEBRA, RIB_OUT, 0, 1)
            iotv.doutbit(VERTEBRA, RIB_OUT, 1, 0)
            iotv.doutbit(VERTEBRA, RIB_OUT, 2, 1)
        if payload == "G":
            iotv.doutbit(VERTEBRA, RIB_OUT, 0, 0)
            iotv.doutbit(VERTEBRA, RIB_OUT, 1, 1)
            iotv.doutbit(VERTEBRA, RIB_OUT, 2, 0)
        if payload == "B":
            iotv.doutbit(VERTEBRA, RIB_OUT, 0, 0)
            iotv.doutbit(VERTEBRA, RIB_OUT, 1, 0)
            iotv.doutbit(VERTEBRA, RIB_OUT, 2, 1)
        if payload == "-":
            iotv.doutbit(VERTEBRA, RIB_OUT, 0, 0)
            iotv.doutbit(VERTEBRA, RIB_OUT, 1, 0)
            iotv.doutbit(VERTEBRA, RIB_OUT, 2, 0)

def on_connect(client, userdata, flags, rc):
    if rc == 0:
        print("Connectat al broker")
        subTopic = ROOT_TOPIC + "/leds" + "/" + NUM_TOY
        client.subscribe(subTopic)
        print("Subscrit a:", subTopic)
    else:
        print("Error de connexió:", rc)

# --- PROGRAMA PRINCIPAL ---
clientName = requests.get("https://nodered.binefa.cat/channel_new")
clientName = "iot-vertebrae-toy-" + clientName.text
print(clientName)
print("Programa actiu. Arrel:", ROOT_TOPIC)

client = mqtt.Client(clientName)
client.on_connect = on_connect
client.on_message = handle_message
client.connect("broker.emqx.io", 8084, 60)
client.loop_start()

last_buttons_value = 0

while True:
    current_buttons = iotv.din(VERTEBRA, RIB_IN)
    if current_buttons != last_buttons_value:
        if current_buttons & 0x1:
            msg = '{"toy": ' + NUM_TOY + ', "color": "M"}'
            client.publish(ROOT_TOPIC + "/sensortouch", msg)
        elif current_buttons & 0x2:
            msg = '{"toy": ' + NUM_TOY + ', "color": "B"}'
            client.publish(ROOT_TOPIC + "/sensortouch", msg)
        elif current_buttons & 0x4:
            msg = '{"toy": ' + NUM_TOY + ', "color": "R"}'
            client.publish(ROOT_TOPIC + "/sensortouch", msg)
        elif current_buttons & 0x8:
            msg = '{"toy": ' + NUM_TOY + ', "color": "G"}'
            client.publish(ROOT_TOPIC + "/sensortouch", msg)
        last_buttons_value = current_buttons
    
    time.sleep(0.1)

client.loop_stop()
client.disconnect()
print("Fi del programa")